//	CAppearance.c

#include "DeviceManager.h"
#include "CAppearance.h"
#include "Carbon68kGlue.h"

Boolean		APR_IsEnabled(void)
{
	return TRUE;
}

void		APR_SetEnabled(Boolean enabledB)
{
}

Boolean		g_black_and_whiteB = FALSE;

RGBColor	*APR_GetColor(APR_ColorType colorType, RGBColor *theColor)
{
	if (colorType <= APR_Color_WHITE) {
		colorType = APR_Color_WHITE;
	}
	
	if (g_black_and_whiteB) {
		
		if (colorType < APR_Color_MEDIUM) {
			colorType = APR_Color_WHITE;
		} else {
			colorType = APR_Color_BLACK;
		}
	}
	
	switch (colorType) {

		case APR_Color_WHITE: {
			theColor->red	= 0xFFFF;
			theColor->green	= 0xFFFF;
			theColor->blue	= 0xFFFF;
			break;
		}

		case APR_Color_VERY_LIGHT: {
			theColor->red	= 54610;
			theColor->green	= 54610;
			theColor->blue	= 54610;
			break;
		}

		case APR_Color_LIGHT: {
			theColor->red	= 43688;
			theColor->green	= 43688;
			theColor->blue	= 43688;
			break;
		}

		case APR_Color_MEDIUM: {
			theColor->red	= 0x8000;
			theColor->green	= 0x8000;
			theColor->blue	= 0x8000;
			break;
		}

		case APR_Color_DARK: {
			theColor->red	= 21844;
			theColor->green	= 21844;
			theColor->blue	= 21844;
			break;
		}

		case APR_Color_VERY_DARK: {
			theColor->red	= 0x2AAA;
			theColor->green	= 0x2AAA;
			theColor->blue	= 0x2AAA;
			break;
		}

		case APR_Color_BLACK: {
			theColor->red	= 0x0000;
			theColor->green	= 0x0000;
			theColor->blue	= 0x0000;
			break;
		}
	}
	
	return theColor;
}

void		APR_SetColor(APR_ColorType colorType)
{
	RGBColor	theColor;
	
	if (g_black_and_whiteB) {
		Pattern		pat;
	
		switch (colorType) {

			case APR_Color_MEDIUM: {
				RGBForeColor(APR_GetColor(APR_Color_BLACK, &theColor));
				GetQDGlobalsGray(&pat);
				PenPat(&pat);
				break;
			}
			
			default: {
				GetQDGlobalsBlack(&pat);
				PenPat(&pat);
				RGBForeColor(APR_GetColor(colorType, &theColor));
				break;
			}
		}
	
	} else {
		RGBForeColor(APR_GetColor(colorType, &theColor));
	}
}

void		APR_SetBackColor(APR_ColorType colorType)
{
	RGBColor	theColor;
	
	RGBBackColor(APR_GetColor(colorType, &theColor));
}

void		APR_BevelFrame(Rect *theRect)
{
	Boolean		wasWB = g_black_and_whiteB;
	
	g_black_and_whiteB = RectDepth(theRect, kMinDepth) < 8;

	APR_SetColor(APR_Color_WHITE);
	MoveTo(theRect->left, theRect->bottom - 2);
	LineTo(theRect->left, theRect->top);
	LineTo(theRect->right - 2, theRect->top);
	
	if (g_black_and_whiteB) {
		APR_SetColor(APR_Color_MEDIUM);
	} else {
		APR_SetColor(APR_Color_LIGHT);
	}
	
	MoveTo(theRect->right - 1, theRect->top + 1);
	LineTo(theRect->right - 1, theRect->bottom - 1);
	LineTo(theRect->left + 1, theRect->bottom - 1);

	APR_SetColor(APR_Color_VERY_LIGHT);
	MoveTo(theRect->left, theRect->bottom - 1);
	Line(0, 0);
	MoveTo(theRect->right - 1, theRect->top);
	Line(0, 0);
	InsetRect(theRect, 1, 1);
	PaintRect(theRect);
	InsetRect(theRect, -1, -1);
	
	APR_SetColor(APR_Color_BLACK);
	
	g_black_and_whiteB = wasWB;
}

void		APR_BevelButton(Rect *theRect, unsigned char *buttonStr, Boolean pressedB)
{
	Boolean		wasWB = g_black_and_whiteB;
	
	g_black_and_whiteB = RectDepth(theRect, kMinDepth) < 8;

	if (pressedB) {
		APR_SetColor(APR_Color_BLACK);
		MoveTo(theRect->left, theRect->bottom - 2);
		LineTo(theRect->left, theRect->top);
		LineTo(theRect->right - 2, theRect->top);
		
		APR_SetColor(APR_Color_VERY_DARK);
		MoveTo(theRect->right - 1, theRect->top + 1);
		LineTo(theRect->right - 1, theRect->bottom - 1);
		LineTo(theRect->left + 1, theRect->bottom - 1);

		APR_SetColor(APR_Color_BLACK);
		MoveTo(theRect->left, theRect->bottom - 1);
		Line(0, 0);
		MoveTo(theRect->right - 1, theRect->top);
		Line(0, 0);
		InsetRect(theRect, 1, 1);

		if (g_black_and_whiteB) {
			APR_SetColor(APR_Color_MEDIUM);
		} else {
			APR_SetColor(APR_Color_VERY_DARK);
		}

		MoveTo(theRect->left, theRect->bottom - 2);
		LineTo(theRect->left, theRect->top);
		LineTo(theRect->right - 2, theRect->top);
		
		APR_SetColor(APR_Color_LIGHT);
		MoveTo(theRect->right - 1, theRect->top + 1);
		LineTo(theRect->right - 1, theRect->bottom - 1);
		LineTo(theRect->left + 1, theRect->bottom - 1);

		if (g_black_and_whiteB) {
			APR_SetColor(APR_Color_BLACK);
		} else {
			APR_SetColor(APR_Color_MEDIUM);
		}
		MoveTo(theRect->left, theRect->bottom - 1);
		Line(0, 0);
		MoveTo(theRect->right - 1, theRect->top);
		Line(0, 0);

		if (g_black_and_whiteB) {
			APR_SetColor(APR_Color_WHITE);
		} else {
			APR_SetColor(APR_Color_MEDIUM);
		}
		InsetRect(theRect, 1, 1);
		PaintRect(theRect);
		InsetRect(theRect, -2, -2);
		APR_SetColor(APR_Color_BLACK);
		
		if (g_black_and_whiteB) {
			APR_SetBackColor(APR_Color_WHITE);
		} else {
			APR_SetBackColor(APR_Color_MEDIUM);
		}
	} else {
		APR_SetColor(APR_Color_DARK);
		MoveTo(theRect->left, theRect->bottom - 2);
		LineTo(theRect->left, theRect->top);
		LineTo(theRect->right - 2, theRect->top);
		
		APR_SetColor(APR_Color_VERY_DARK);
		MoveTo(theRect->right - 1, theRect->top + 1);
		LineTo(theRect->right - 1, theRect->bottom - 1);
		LineTo(theRect->left + 1, theRect->bottom - 1);

		APR_SetColor(APR_Color_VERY_DARK);
		MoveTo(theRect->left, theRect->bottom - 1);
		Line(0, 0);
		MoveTo(theRect->right - 1, theRect->top);
		Line(0, 0);
		InsetRect(theRect, 1, 1);
		APR_BevelFrame(theRect);
		InsetRect(theRect, -1, -1);
		
		APR_SetBackColor(APR_Color_VERY_LIGHT);
	}

	if (buttonStr) {
		MoveTo(theRect->left + 7, theRect->bottom - 7);
		DrawString(buttonStr);
	}
	
	APR_SetBackColor(APR_Color_WHITE);

	g_black_and_whiteB = wasWB;
}

/*
RGBColor	RGBToGray(RGBColor *rgbP)
{
	#if __POWERPC__
		CMConvertRGBToHLS(
		  const CMColor *  src,
		  CMColor *        dst,
		  UInt32           count)                                     
	#else
		CMRGBToHLS(
			ComponentInstance ci, 
			const CMColor *src, 
			CMColor *dst, 
			unsigned long count)
	#endif
}
*/